function BayesRegressionTest;
%	BAYESREGRESSIONTEST - BayesRegressionTest;
n=10;
m=2000;
X=[ones(n,1) 2*randn(n,1)];
sde = .1;
Coeff=[3;5];
y = X*Coeff+sde*randn(n,1);

Xbad = [ones(n,1) zeros(n,1)];
y = Xbad*Coeff+sde*randn(n,1);
disp('X matrix has zero data. (To check error conditions.)');
CPrior.mu = [3;5];
CPrior.cov = [.1^2 0; 0 .2^2];
CPosterior = BayesRegressionUpdate(CPrior, y, Xbad, sde^2);
disp(['Return code:' int2str(CPosterior.ret)]);

Xbad = ones(n,2);
y = Xbad*Coeff+sde*randn(n,1);
disp('X matrix has singular data. (To check error conditions.)');
CPrior.mu = [3;5];
CPrior.cov = [.1^2 0; 0 .2^2];
CPosterior = BayesRegressionUpdate(CPrior, y, Xbad, sde^2);
disp(['Return code:' int2str(CPosterior.ret)]);
error('done');

disp('Coefficients with improper priors.');
CPrior.mu = 0;
CPrior.cov = inf;
CPosterior = BayesRegressionUpdate(CPrior, y, X, sde^2);
p = mvnrnd(CPosterior.mu, CPosterior.cov, m);
disp(['Posterior mean (population): ', num2str(CPosterior.mu')]);
disp(['Posterior mean (sample):     ' num2str(mean(p))]);
disp('Posterior cov (population):  ');
disp(num2str(CPosterior.cov));
disp('Posterior cov (sample):  ');
disp(num2str(cov(p)));

disp('Coefficients with proper priors.');
CPrior.mu = [3;5];
CPrior.cov = [.1^2 0; 0 .2^2];
CPosterior = BayesRegressionUpdate(CPrior, y, X, sde^2);
p = mvnrnd(CPosterior.mu, CPosterior.cov, m);
disp(['Posterior mean (population): ', num2str(CPosterior.mu')]);
disp(['Posterior mean (sample):     ' num2str(mean(p))]);
disp('Posterior cov (population):  ');
disp(num2str(CPosterior.cov));
disp('Posterior cov (sample):  ');
disp(num2str(cov(p)));


return;
C = update(C, vy, mx, sde^2);
V = update(V, vy-mx*vCoeff);
p = zeros(m,3);
for i=1:m
   p(i,1:2)=PosteriorDraw(C)';
   p(i,3) = PosteriorDraw(V);
end
[r,s]=gibbs_summary(p);
disp([r,num2str(s)]);

C=BayesianRegressionCoefficient([1;8],[.0001,0;0,.0005]);
C = update(C, vy, mx, sde^2);
V = update(V, vy-mx*vCoeff);
p = zeros(m,3);
for i=1:m
   p(i,1:2)=PosteriorDraw(C)';
   p(i,3) = PosteriorDraw(V);
end
[r,s]=gibbs_summary(p);
disp([r,num2str(s)]);

